close all
clear all
prep_figure

load('FIMS')

minx = -16;
maxx = 8;
margh = [0.12,0.01];
margw = [0.075,0.01];

figure
xx1 = [EW{:}];
group1 = bsxfun(@times,ones(size(xx1,1),1),1:25);
color1 = bsxfun(@times,ones(size(xx1,1),1),kron(ones(1,5),1:5));

PEW = cellfun(@(x)transpose(x),PEW,'UniformOutput',false);
xx2 = [PEW{:}];
tmp = cellfun(@(x,y) y*ones(size(x)),PEW,mat2cell(reshape(1:25,[5,5]),ones(5,1),ones(5,1)),'UniformOutput',false);
group2 = [tmp{:}];
tmp = cellfun(@(x,y) y*ones(size(x)),PEW,mat2cell(kron(ones(5,1),1:5),ones(5,1),ones(5,1)),'UniformOutput',false);
color2 = [tmp{:}];

REW = cellfun(@(x)transpose(x),REW,'UniformOutput',false);
xx3 = [REW{:}];
tmp = cellfun(@(x,y) y*ones(size(x)),REW,mat2cell(reshape(1:25,[5,5]),ones(5,1),ones(5,1)),'UniformOutput',false);
group3 = [tmp{:}];
tmp = cellfun(@(x,y) y*ones(size(x)),REW,mat2cell(kron(ones(5,1),1:5),ones(5,1),ones(5,1)),'UniformOutput',false);
color3 = [tmp{:}];

xx = [xx1(:)',xx2,xx3];
group = [group1(:)',group2,group3];
color = [color1(:)',color2,color3];
grid = [ones(size(xx1(:)')),2*ones(size(xx2)),3*ones(size(xx3))];
cutoff = 1e-45;
g = gramm('x',log10(xx),'subset',xx>cutoff,'group',group,'color',color);
g.facet_grid(grid,[]);
g.stat_density();
g.axe_property('XLim',[-45,10],'XTick',-40:10:10,'XTickLabel',arrayfun(@(x) ['10^{' num2str(x) '}'],-40:10:10,'UniformOutput',false))
g.no_legend();
g.draw();

makeFigure(0,0,2,300,200,'figure_prediction_uncertainty',true)

figure

gbar = gramm('x',[1,1,1],...
    'y',[sum(xx1(:)>cutoff)/length(xx1(:))*100,...
    sum(xx2>cutoff)/length(xx2)*100,...
    sum(xx3>cutoff)/length(xx3)*100]);
gbar.facet_grid([1,2,3],[]);
gbar.no_legend();
gbar.axe_property('YLim',[0,100])
gbar.geom_bar('stacked',true);
gbar.draw();

makeFigure(0,0,2,50,200,'figure_prediction_uncertainty_nonzero',true)
