clear all
prep_figure
close all

T = readtable('/data/intogen-catalog-data.csv');

names_intogen = cellfun(@(x,y) [x '-[' y ']'],T{:,1},T{:,2},'UniformOutput',false);
names = regexprep(strrep(mut_names,'MUT_MutAA',''),'(\[[\w0-9]*\])-([\w0-9]*)','$2-$1');
y = sum(mutations,2)/120*100;
y_intogen = cellfun(@(x)max([0,T{find(strcmp(x,names_intogen)),3}/6792*100]),names);
[~,sort_y] = sort(y,'descend');

colors = {'CCLE','intogen'};

figure
g = gramm('x',{names{:},names{:}},'y',[y;y_intogen],'color',colors([ones(length(names),1);2*ones(length(names),1)]));
g.geom_bar('stacked',false,'dodge',0.8);
g.axe_property('XTickLabelRotation',90);
g.set_names('x','mutation','y','occurence [%]');
g.set_order_options('x',names(sort_y));
g.no_legend();
g.draw


makeFigure(0,0,2,160,130,'figure_mutations',true)