clear all
prep_figure
close all
ll = lines(7);

xx = nanmin(nanmin(data_fit(:,:,8,:,:),[],5),[],4);

data_fit = data_fit(find(any(~isnan(xx),2)),:,:,:,:);
sim_fit = sim_fit(find(any(~isnan(xx),2)),:,:,:,:);
mutations = mutations(:,find(any(~isnan(xx),2)));
cell_lines = cell_lines(find(any(~isnan(xx),2)));
tissue = tissue(find(any(~isnan(xx),2)));
m_ccle = m_ccle(find(any(~isnan(xx),2)),:,:);
sd_ccle = sd_ccle(find(any(~isnan(xx),2)),:,:);

filteridx = ones(size(data_fit,1),7);
fcolumns = 14;
frows = 14;
mainwidth = 1:fcolumns-1;
gap = [0.02,0.01];
marg_h = [0.05,0.05];
marg_w = [0.06,0];

imscresize=10;

data = nanmin(data_fit(:,:,8,:,1),[],4);

figure
subtightplot(frows,fcolumns,[[mainwidth]+9*fcolumns,[mainwidth]+10*fcolumns,[mainwidth]+11*fcolumns,[mainwidth]+12*fcolumns,[mainwidth]+13*fcolumns],gap,marg_h,marg_w)
[sortidx,drugidx] = boxPlotFit(data_fit(:,:,8,:,:),sim_fit(:,:,8,:,:),cell_lines,1,tissue,filteridx);
xlim([0.5,length(I)-2.5])
xlabel('cell lines')
ylabel({'median maximal','squared endpoint error'})
ylim([0,0.8])
set(gca,'TickLength',[0,0])
set(gca,'YGrid','on')

subtightplot(frows,fcolumns,[fcolumns*8+[mainwidth]],gap,marg_h,marg_w)
imshow(not(mutations(:,sortidx)))
imagesc(kron(not([any(mutations(cellfun(@(x) ~isempty(strfind(x,'KRAS')),mut_names),sortidx));...
    any(mutations(cellfun(@(x) ~isempty(strfind(x,'NRAS')),mut_names),sortidx));...
    any(mutations(cellfun(@(x) ~isempty(strfind(x,'BRAF')),mut_names),sortidx));...
    any(mutations(cellfun(@(x) ~isempty(strfind(x,'PIK3CA')),mut_names),sortidx))...
    ]),ones(imscresize)))
set(gca,'XTick',[])
ylim([0.5,4*imscresize+0.5])
xlim([0.5,(length(I)-3)*imscresize+0.5])
set(gca,'YTick',(1:4)*imscresize - imscresize/2)
set(gca,'YTickLabel',{'KRAS','NRAS','BRAF','PIK3CA'})
set(gca,'TickLength',[0,0])
ylabel('mutations')
for i = 1:10
    hold on
    plot([0.5,(length(I)-2.5)*imscresize],[0.5+i*imscresize 0.5+i*imscresize],'k-')
end

drugorder = [1,2,7,4,5,3,6];
invdrugorder(drugorder) = 1:7;
subtightplot(frows,fcolumns,[6*fcolumns+mainwidth,7*fcolumns+[mainwidth]],gap,marg_h,marg_w)
tmp = nanmin(nanmin(data_fit(:,:,8,:,:),[],4),[],5);
imagesc(kron(tmp(sortidx,drugorder)',ones(imscresize)))
set(gca,'XTick',[])
ylim([0.5,length(drugs)*imscresize+0.5])
xlim([0.5,(length(I)-3)*imscresize+0.5])
set(gca,'YTick',(1:7)*imscresize-imscresize/2)
set(gca,'YTickLabel',drugs(drugorder))
colormap([1,1,1;1-bsxfun(@times,1-gray(256),1-ll(7,:)); 1 1 1;1-flipud(bsxfun(@times,1-gray(256),1-ll(1,:)))]);
caxis([0,2])
set(gca,'TickLength',[0,0])
for idrug =1:length(drugorder)
   hold on
   mdata = find(isnan(data(sortidx,drugorder(idrug))));
   plot(mdata*imscresize-(imscresize-1)/2,ones(size(mdata))*idrug*imscresize-(imscresize-1)/2,'kx','MarkerSize',9)
end
% for icell = 1:length(drugidx)
%     didx = invdrugorder(drugidx(sortidx(icell)));
%     line([0.5 + icell-1,0.5 + icell],[0.5 + didx,0.5 + didx],'Color','k')
%     line([0.5 + icell-1,0.5 + icell],[0.5 + didx-1,0.5 + didx-1],'Color','k')
%     line([0.5 + icell,0.5 + icell],[0.5 + didx,0.5 + didx-1],'Color','k')
%     line([0.5 + icell-1,0.5 + icell-1],[0.5 + didx,0.5 + didx-1],'Color','k')
% end


Pos = get(gca,'Position');

ff = gcf;
bplot = ff.Children(3);
cPos = get(bplot,'Position');
cPos(1) = Pos(1);
cPos(3) = Pos(3);
set(bplot,'Position',cPos);

subtightplot(frows,fcolumns,[7*fcolumns,fcolumns*8],gap,marg_h,marg_w)
cb = colorbar('Location','WestOutside');
caxis([0,2])
ylabel(cb,'relative proliferation [%]')
set(cb,'YTickLabel',arrayfun(@num2str,get(cb,'YTick')*100,'UniformOutput',false))
set(gca,'visible','off');

makeFigure(0,0,2,510,300,'figure_fit1',true)
%%
figure

subtightplot(frows,fcolumns,reshape(bsxfun(@plus,repmat(1:6,[6,1]),((0:5)*fcolumns)'),[1,36]),gap+[0,0],marg_h+[-0.00,0.0],marg_w+[-0.05,0.05])
corr_fit_all = dscatter_fit(data_fit(:,:,8,:,:),sim_fit(:,:,8,:,:),filteridx,'no filter');
A = arrayfun(@(x)reshape(bsxfun(@plus,bsxfun(@plus,repmat(1:2,[2,1]),((0:1)*fcolumns)'),x*2)+4,[1,4]),1:4,'UniformOutput',false);
B = arrayfun(@(x)reshape(bsxfun(@plus,bsxfun(@plus,repmat(1:2,[2,1]),((2:3)*fcolumns)'),x*2)+4,[1,4]),1:4,'UniformOutput',false);
drugplots = {A{:},B{:}};
for idrug = 1:7
    subtightplot(frows,fcolumns,drugplots{idrug},gap+[-0.03,0],marg_h+[-0.11*floor(idrug/5),0.11*floor(idrug/5)],marg_w+[-0.06,0.06])
    tmp = dscatter_fit(data_fit(:,idrug,8,:,:),sim_fit(:,idrug,8,:,:),filteridx,drugs{idrug});
    for icv = 1:5
        tmpx = nanmedian(data_fit(:,idrug,8,icv,:),5);
        tmpy = nanmedian(sim_fit(:,idrug,8,icv,:),5);
        C = corrcoef(tmpx(~isnan(tmpx)),tmpy(~isnan(tmpy)));
        corr_fit_drug(idrug,icv) = C(1,2);
    end
    xlabel('')
    ylabel('')
    set(gca,'XTick','','YTick','')
end
for itissue = 1:5
    for icv = 1:5
        tmpx = data_fit(tissue==itissue,:,8,icv,:);
        tmpy = sim_fit(tissue==itissue,:,8,icv,:);
        C = corrcoef(tmpx(~isnan(tmpx)),tmpy(~isnan(tmpy)));
        corr_fit_tis(itissue,icv) = C(1,2);
    end
end

subtightplot(frows,fcolumns,drugplots{8},gap+[-0.03,0],marg_h+[-0.11*floor(idrug/5),0.11*floor(idrug/5)],marg_w+[-0.06,0.06])
colorbar

subtightplot(frows,fcolumns,reshape(bsxfun(@plus,repmat(1:2,[6,1]),((7:12)*fcolumns)'),[1,12]),gap+[0,0],marg_h+[-0.00,0.0],marg_w+[-0.05,0.05])

boxplot([corr_fit_drug(drugorder,:);corr_fit_tis]','BoxStyle','filled','Colors',[0.7,0.7,0.7],'MedianStyle','line','Notch','off','Symbol','.')
ylim([0,1])
ylabel('correlation coefficient')
set(gca,'XTick',[])
makeFigure(0,0,2,500,300,'figure_fit2',true)


%%
figure

sel_cell = [1,20,40,60,80,100];
sel_drug = [5, 2, 3, 4, 1,  6];
for icell = 1:length(sel_cell)
    subtightplot(frows,fcolumns,[6*fcolumns+[1:2]+(icell-1)*2,7*fcolumns+[1:2]+(icell-1)*2],gap,marg_h,marg_w)
    cidx = sortidx(sel_cell(icell));
    didx = sel_drug(icell);
    squeeze(nanmin(nanmedian(data_fit(cidx,didx,:,:,:),5),[],4));
    errorbar([2.5,8,25,80,250,800,2500,8000],squeeze(m_ccle(cidx,didx,:)),squeeze(sd_ccle(cidx,didx,:)),'k.')
    hold on
    for icv = 1:5
        plot([2.5,8,25,80,250,800,2500,8000],squeeze(nanmedian(sim_fit(cidx,didx,:,icv,:),5)),'k-')
    end
    xlabel('drug concentration [nM]')
    if(icell == 1)
    ylabel('relative proliferation')
    else
        ylabel('')
        set(gca,'YTick',[])
    end
    set(gca,'XScale','log')
    ylim([0,1.2])
    xlim([2,1e4])
    title([ strrep(cell_lines{cidx},'TUMOR-','') ' - ' drugs{didx} ])
    
end

makeFigure(0,0,2,500,300,'figure_fit3',true)

