clear all
prep_figure
load('time_benchmark_all')
load('time_benchmark_parallel_all')
close all



figure

gradient = {'forward','adjoint','parallel + adjoint'}
solver = {'dense','sparse'}

N1 = size(time_benchmark,1);
N2 = size(time_benchmark_parallel,1);
xx = gradient([2*ones(2*N1,1);1*ones(2*N1,1);3*ones(N2,1)]);
methods = solver([2*ones(N1,1);1*ones(2*N1,1);2*ones(N1+N2,1)]);
scaling = nanmedian(time_benchmark_parallel(:,1))/median(time_benchmark(:,1));
yy = log10([time_benchmark(:)*scaling;time_benchmark_parallel(:,2)]/3600);

g(1,1)=gramm('x',xx,'y',yy,...
    'color',methods...
    );
g(1,1).stat_boxplot('width',0.5,'dodge',0);
g(1,1).set_names('x','gradient computation scheme','y','comp. time per gradient eval. [h]','color','solver');
g(1,1).set_order_options('x',[2,1,3]);
g(1,1).axe_property('TickLabelInterpreter','tex','YLim',[-1,6],'YTick',-2:2:10,'YGrid','on');

g.draw()
set(g(1,1).facet_axes_handles,'YTickLabel',arrayfun(@(x) ['10^{' num2str(x) '}'],get(g(1,1).facet_axes_handles,'YTick'),'UniformOutput',false))

makeFigure(0,0,2,150,100,'figure_benchmark',true)