clear all
close all
prep_figure

% Erlotinib: 2 nM in vitro, 20 nM in vivo http://cancerres.aacrjournals.org/content/canres/67/3/1228.full.pdf
% 
% Lapatinib: ~10 nM http://www.selleckchem.com/products/lapatinib.html https://www.ncbi.nlm.nih.gov/pubmed/12467226
% 
% PD-0325901: ~0.3 nM http://www.selleckchem.com/products/PD-0325901.html https://www.ncbi.nlm.nih.gov/pubmed/18952427
% 
% PLX4720: 13 nM http://www.selleckchem.com/products/PLX-4720.html https://www.ncbi.nlm.nih.gov/pubmed/18287029
% 
% RAF265: 40 nM http://www.selleckchem.com/products/RAF265(CHIR-265).html https://www.ncbi.nlm.nih.gov/pubmed/26396681
% 
% Selumetinib/AZD6244: 10-14nM http://www.selleckchem.com/products/AZD6244.html
% 
% Vandetanib/ZD-6474: 40nM (VEGFR) 500nM EGFR http://www.selleckchem.com/products/Vandetanib.html https://www.ncbi.nlm.nih.gov/pubmed/12183421 https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2362058/

invitro_ic50 = [0.67,2.4,0.33,100,330,99,9.5];


conc = I{1}.conc(1:8);

y = ones(size(m_ccle,1)*size(m_ccle,2)*6,size(m_ccle,3));
color = ones(size(m_ccle,1)*size(m_ccle,2)*6,size(m_ccle,3));
for idrug = 1:size(m_ccle,2)
    y((size(m_ccle,1)*(idrug-1)+1):(size(m_ccle,1)*idrug),:) = squeeze(m_ccle(:,idrug,:));
    color((size(m_ccle,1)*(idrug-1)+1):(size(m_ccle,1)*idrug),:) = 1;
    for icv = 1:5
        y(icv*numel(m_ccle(:,:,1))+((size(m_ccle,1)*(idrug-1)+1):(size(m_ccle,1)*idrug)),:) = squeeze(nanmedian(sim_fit(:,idrug,:,icv,:),5));
        color(icv*numel(m_ccle(:,:,1))+((size(m_ccle,1)*(idrug-1)+1):(size(m_ccle,1)*idrug)),:) = 2;
    end
end


rows = kron(ones(1,6),kron(1:size(m_ccle,2),ones(1,size(m_ccle,1))));
%%


figure
g = gramm('x',conc','y',y,'color',color(:,1))
g.facet_grid([],drugs(rows')');
g.stat_summary('type','95percentile','geom','lines')
% g.stat_fit('fun',@(param1,param2,x) 1/(1+exp(param2*(x-param1))),'StartPoint',[1,1]);
% g.geom_line();
g.axe_property('XScale','log','Ylim',[0,1.5],'XTick',[1e0,1e1,1e2,1e3,1e4],'XLim',[1e-1,1e4])
g.set_names('y','relative proliferation','x','drug concentration [nM]','row','drug');
g.set_order_options('column',drugs)
g.draw()

for idrug = 1:7
    
    line(g.facet_axes_handles(idrug),[invitro_ic50(idrug),invitro_ic50(idrug)],[0,1.5])
end

makeFigure(0,0,2,500,80,'figure_average_response',true)

%%
figure
g = gramm('x',log10(ic50_ccle(ic50_ccle>0))+3);
rows = (1:7) + zeros(size(ic50_ccle));
g.facet_grid([],drugs(rows(ic50_ccle>0)));
g.stat_density('extra_x',1);
g.set_order_options('column',drugs)
g.axe_property('XLim',[-1,4],'YLim',[0,1.25])
g.draw();
makeFigure(0,0,2,500,80,'figure_stat_ic50',true)


%%
figure
g = gramm('x',log10(ec50_ccle(ec50_ccle>0))+3);
rows = (1:7) + zeros(size(ec50_ccle));
g.facet_grid([],drugs(rows(ec50_ccle>0)));
g.stat_density('extra_x',1);
g.set_order_options('column',drugs)
g.axe_property('XLim',[-1,4],'YLim',[0,1.25])
g.draw();
makeFigure(0,0,2,500,80,'figure_stat_ec50',true)

%%

