function [corr,p] = dscatter_fit(xx,yy,filteridx,label)
xx=bsxfun(@times,xx,0./filteridx+1);
yy=bsxfun(@times,yy,0./filteridx+1);
xx=nanmedian(xx,5);
yy=nanmedian(yy,5);
dscatter(xx(~isnan(yy)),yy(~isnan(yy)));
xlabel('data')
ylabel('simulation')
[C,P] = corrcoef(xx(~isnan(yy)),yy(~isnan(yy)));
% title({[label ': r=' num2str(C(1,2)) ],[' p=' num2str(P(1,2)) ' n=' num2str(numel(yy(~isnan(yy))))]})
title({[label ': r=' num2str(C(1,2),'%10.2f\n') ]})
hold on
plot([0,2],[0,2],'k:','LineWidth',2)
xlim([0,1.2])
ylim([0,1.2])
axis square
corr = C(1,2);
p = P(1,2);
box on
end
