function [sortidx,drugidx] = boxPlotFit(data,sim,labels,orderflag,tissues,filteridx)
tmp = bsxfun(@(x,y) abs(x-y).^2,data,sim);
tmp = bsxfun(@times,tmp,filteridx);
tmp = nanmedian(tmp,5);
[~,drugidx] = max(nanmedian(tmp,4),[],2);
err = tmp(:,drugidx,:,:);
err = nansum(bsxfun(@times,eye(size(err,1)),err),2);
err(err==0) = NaN;
err = err(:,:);
switch(orderflag)
    case 1
        mobj = nanmedian(err,2);
        [~,sortidx] = sort(mobj);
    case 2
        xx = nanmin(nanmin(data(:,:,:,:,:),[],5),[],4);
        Dcell = pdist(xx,@(x,y) nansum(sqrt((x-y).^2),2));
        tree_cell = linkage(Dcell,'ward');
        sortidx = optimalleaforder(tree_cell,Dcell);
    otherwise
        sortidx = 1:size(obj,1);
end
boxplot(transpose(err(sortidx,:)),'BoxStyle','filled','Colors',[0.7,0.7,0.7],'MedianStyle','line','Notch','off','Symbol','.')
h = findobj(gca,'Tag','Box');
cmap = lines(5);
for j=1:length(h)
    h(length(h)-j+1).Color = cmap(tissues(sortidx(j)),:);
end
set(gca,'XTickLabel',strrep(labels(sortidx),'TUMOR-',''),'FontSize',8)
set(gca,'XTickLabelRotation',90)

end