This folder contains the code used to obtained the results presented in the manuscript as well as the result files.

## M-files used to generate the figures in the manuscript:


__figure_BioModels.m__: 	            produces figure which was used to generate Figure 1 c) and d)
						            _Comparison of complexity of the proposed model with curated models from the BioModels database_

__figure_mutations.m__: 		        produces figure which was used to generate Figure 2 b)
					                _Comparison of the occurrence frequency of mutations included in the model between the 
						            training/test set extracted from the Cancer Cell Line Encyclopedia and the InTOGen
						            database_

__figure_benchmark.m__:			    produces figure which was used to generate Figure 3 a)
								    _Computation time for one evaluation of the objective function gradient_

__figure_convergenceCurve.m__: 	    produces figure which was used to generate Figure 3 b)
								    _Objective function traces for ten different local optimization runs for the first cross-validation set_

__figure_fit.m__:				    produces figures which were used to generate Figure 4 a) and Supplementary Figure S5
							        _Analysis of fitting properties of the model_

__figure_correlation.m__:		    produces figures which were used to generate Figure 4 b)
							        _Analysis of concentration and drug dependence of RMSE and correlation_

__figure_corr_tissue.m__:		    produces figure which was used to generate Figure 4 c)
							        _Analysis of tissue and drug dependence of RMSE and correlation_

__figure_generalization.m__: 	    produces figures which were used to generate Figure 5							         		
                                    _Analysis of generalization properties of the model and comparison to statistical models_

__figure_prediction_uncertainty.m__: produces figure which was used to generate Figure 6 a)
							    _Eigenvalues densities of the Fisher Information Matrix for parameters, state variables and
							    proliferation readouts_

__figure_predictionuncertainty.m__:	produces figure which was used to generate Figure 6 b) and 6c)
							    _Spread of parameter estimates and analysis of mean squared error decomposition_

__figure_par_identifiability.m__: 	produces figure which was used to generate Figure 6 d)
							    _Analysis of equilibrium constant estimate_

__figure_synergy_MTC.m__:	        produces figures which were used to generate Figure 7
	                            _Analysis of combination treatment predictions_

__figure_average_dose_response.m__:	produces figure which was used to generate Figure S3
	                            _Analysis of of measured and simulated average dose response behaviour_

## Auxiliary routines :
__getSelMS.m__: 						routine to select best multistarts

__makeFigure.m__:					polishes figure (ghostscript processing currently disabled)

__prep_figure.m__: 					auxiliary routine that loads data and adds paths

__boxPlotFit.m__: 					plotting routine used in figure_fit

__preprocess.m__: 					auxiliary routine that loads CCLE drug response data and predictions from the parameterized models
								and stores them in a common format
								
dxdotdp_model_ErbB.m  			parameter derivative of rhs of model

__J_model_ErbB.m__: 				    state derivative of rhs of model

__bonf_holm.m__:						routine for bonferroni-holm multiple testing correction

__dscatter_fit.m__: 					wrapper routine for dscatter

__dscatter.m__: 						density scatter plot

## Input data for modelling and parameter estimation:
__mutations.mat__: 					mutation data for considered cell-lines from CCLE database (generated from prep_figure.m)

__pnames.mat__:						parameter name information

__rnames.mat__:						reaction name information

__m_sd_ccle.mat__: 					processed dose response data for considered cell-lines from CCLE database (generated from prep_figure.m)

__TissueOrigin_CelllinesInExperimentalTable.csv__:		tissue origins for considered cell-lines from CCLE database

__intogen-catalog-data.csv__: 		intogen data for global mutation status of human tumors


## Results of parameter estimation and cross-validation:
__Rall.mat__: 						parameter estimation results, these results were obtained using the routines presented in the estimation_example folder

__FIMS.mat__: 						results file with prediction uncertainty results

__preprocessed.mat__: 				results file with preprocessed simulation results for the mechanistic model
								on the training, test and independent test set 
								
__time_benchmark_all.mat__: 			results file for benchmark results

__time_benchmark_parallel_all.mat__:	results file for parallelized benchmark results

__preprocessed_stat.mat__:			results for statistical models

__preprocessed_GDSC.mat__:			results for data from GDSC database

__gdsc_from_ccle_sigmoid.mat__:		interpolation of data from CCLE database to GDSC database

__preprocessed_rand[1-10].mat__:		results for random parameter values

## Results of drug synergy predictions:
__preprocessed_MCT.mat__: 			data file with single treatment results from ONeill et al.

__preprocessed_MCT_combi.mat__: 		data file with combination treatment results ONeill et al.

## Input data for comparison of model sizes:
__biomodels_modeldims.mat__: 		model sizes from biomodels database obtained from the curated branch of biomodels

## List of folders with short description:
__gramm__: 							figure engine in matlab (https://github.com/piermorel/gramm)

__export_fig__:						figure export in matlab (https://de.mathworks.com/matlabcentral/fileexchange/23629-export-fig)

__subtightplot__: 					subplots in matlab (https://de.mathworks.com/matlabcentral/fileexchange/39664-subtightplot)

## Contact:
For question regarding the model and the implementation, please contact:

Fabian Fröhlich (fabian.froehlich@helmholtz-muenchen.de) or Jan Hasenauer (jan.hasenauer@helmholtz-muenchen.de)

Institute of Computational Biology

Helmholtz Zentrum München

