This folder contains 
1) the pathway model,
2) the parameter estimation pipeline, and
3) the visualisation methods
used to obtain the results presented in Fröhlich et al. (2017). In addition,
4) the parameter estimation results are provide and
5) an example for the parameter estimation.

__SBML file:__
The developed pathway model is provided as an SBML file: `CS_Signalling_ERBB_RAS_AKT.xml`
This file comes with a comprehensive annotation and a set of parameters obtained by optimisation. The model can be loaded using a range of toolboxes, including COPASI. However, due to the size of the model, most tools are not able to simulate the model. For simulation, we suggest to use the provided MATLAB code which is generated from this SBML file.

__Code for numerical simulation:__
The numerical simulation and gradient calculation for optimisation was performed using AMICI. The employed commit provided in the folder ICB-DCM-AMICI-35f18fe [doi:10.5281/zenodo.597753](http://doi.org/doi:10.5281/zenodo.597753). AMICI provides an SBML import which was used to import `CS_Signalling_ERBB_RAS_AKT.xml`.

__Code for parameter estimation:__
The parameter estimation was performed using PESTO. The employed commit provided in the folder ICB-DCM-PESTO-649f3d2 [doi.org/10.5281/zenodo.579891](http://doi.org/10.5281/zenodo.579891).

__Example for parameter estimation:__
An example for the use of the code in provided in the folder `./estimation_example`. This example demonstrates among others
- the compilation of the model,
- the simulation of artificial data using the compiled model and
- the estimation of the model parameter.
To execute the example, please run `runSyntheticExample.m`. This uses the imported version of the SBML model (`model_ErbB_syms.m`) and the likelihood function (`likelihood_all_ErbB.m`).
Remark: The script might take several hours to complete.

__Results files:__
The code obtained to generate the results presented in the manuscript as well as the result files are provided in the folder `./scripts`. A detailed description is provide in the README file of the corresponding folder.

__Contact:__
For question regarding the model and the implementation, please contact:

Fabian Fröhlich (fabian.froehlich@helmholtz-muenchen.de) or Jan Hasenauer (jan.hasenauer@helmholtz-muenchen.de)

Institute of Computational Biology

Helmholtz Zentrum München

